/**
 * AilAudioSinkRecord.h
 *
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: D. Girnus / ADITG/SW2 / dgirnus@de.adit-jv.com
*          S. Pujari / (RBEI/ECF3) / SonaliSajan.Pujari@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AILAUDIOSINKRECORD_H_
#define AILAUDIOSINKRECORD_H_


#include <stdio.h>
#include <fcntl.h>
#include <string>
#include <sstream>

#include <aauto/common.h>


namespace adit { namespace aauto
{

#define WAV_HEADER_OFFSET       44

struct t_wav_header {
    char            ChunkID[4];        // ChunkID: RIFF Header - Magic header
    /* This is the size of the entire file in bytes
     * minus 8 bytes for the two fields not included in this count:
       ChunkID and ChunkSize. */
    uint32_t        ChunkSize;      // RIFF Chunk Size
    char            Format[4];         // WAVE Header - string "WAVE"
    char            Subchunk1ID[4];    // FMT header - string "fmt "
    uint32_t        Subchunk1Size;  // Size of the fmt chunk
    unsigned short  AudioFormat;    // Audio format 1=PCM,6=mulaw,7=alaw, 257=IBM Mu-Law, 258=IBM A-Law, 259=ADPCM
    unsigned short  NumOfChan;      // Number of channels 1=Mono 2=Stereo
    uint32_t        SamplesPerSec;  // Sampling Frequency in Hz
    uint32_t        bytesPerSec;    // bytes per second
    unsigned short  blockAlign;     // 2=16-bit mono, 4=16-bit stereo
    unsigned short  bitsPerSample;  // Number of bits per sample
    char            Subchunk2ID[4];    // SubChunk2Id - string "data"
    uint32_t        Subchunk2Size;  // Sampled data length
};

class AilAudioSinkRecord
{
public:
    AilAudioSinkRecord(void) {
        mFile = nullptr;
        mFileCount = 0;
    };
    ~AilAudioSinkRecord() {};
    int open(std::string fileName, std::string sinkName);
    int close(void);
    int write(const void *ptr, unsigned int size);
    int createWavHeader(int codec, int numChannels, int numBitsPerSample, int sampleRate);

private:
    int getRawDataFileSize();

    std::string mSinkName;

    FILE* mFile;

    unsigned int mFileCount;

};

} } /* namespace adit { namespace aauto */

#endif /* AILAUDIOSINKRECORD_H_ */
